<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Mautic\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * AJAX handler for the authorize action
 *
 * @since 1.0.0
 */
function automatorwp_mautic_ajax_authorize() {
    // Security check
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $prefix = 'automatorwp_mautic_';

    $client_id = sanitize_text_field( $_POST['client_id'] );
    $client_secret = sanitize_text_field( $_POST['client_secret'] );

    // Sanitize URL
    $mautic_url = esc_url_raw( trim( $_POST['url'] ) );
    $mautic_url = untrailingslashit( $mautic_url );

    $disable_sslverify = $_POST['disable_ssl'];
    
    if ( $disable_sslverify === 'true' ) {
        $disable_sslverify = 'on';
    } else{
        $disable_sslverify = false;
    }
   
    // Check parameters given
    if( empty( $mautic_url ) || empty( $client_id ) || empty( $client_secret ) ) {
        wp_send_json_error( array( 'message' => __( 'All fields are required to connect with Mautic', 'automatorwp-pro' ) ) );
        return;
    }

    // Save Client ID and Client secret
    $settings = get_option( 'automatorwp_settings' );

    $settings[$prefix . 'client_id'] = $client_id;
    $settings[$prefix . 'client_secret'] = $client_secret;
    $settings[$prefix . 'url'] = $mautic_url;
    $settings[$prefix . 'disable_ssl'] = $disable_sslverify;

    update_option( 'automatorwp_settings', $settings );

    $admin_url = admin_url('admin.php?page=automatorwp_settings&tab=opt-tab-mautic');
    
    $redirect_url = $mautic_url . '/oauth/v2/authorize?client_id='. $client_id . '&grant_type=authorization_code&redirect_uri=' . urlencode( $admin_url ) . '&response_type=code&state=UNIQUE_STATE_STRING';

    wp_send_json_success( array(
        'message' => __( 'Settings saved successfully, redirecting to Mautic...', 'automatorwp-pro' ),
        'redirect_url' => $redirect_url
    ) );
}
add_action( 'wp_ajax_automatorwp_mautic_authorize',  'automatorwp_mautic_ajax_authorize' );

/**
 * Ajax function for selecting segments
 *
 * @since 1.0.0
 */
function automatorwp_mautic_ajax_get_segments() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';
    
    $segments = automatorwp_mautic_get_segments( );

    $results = array();

    // Parse segment results to match select2 results
    foreach ( $segments as $segment ) {

        $results[] = array(
            'id' => $segment['id'],
            'text' => $segment['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_mautic_get_segments', 'automatorwp_mautic_ajax_get_segments' );

/**
 * Ajax function for selecting companies
 *
 * @since 1.0.0
 */
function automatorwp_mautic_ajax_get_companies() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';
    
    $companies = automatorwp_mautic_get_companies( );

    $results = array();

    // Parse company results to match select2 results
    foreach ( $companies as $company ) {

        $results[] = array(
            'id' => $company['id'],
            'text' => $company['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_mautic_get_companies', 'automatorwp_mautic_ajax_get_companies' );

/**
 * Ajax function for selecting contact fields
 *
 * @since 1.0.0
 */
function automatorwp_mautic_ajax_get_contact_fields() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';
    
    $contact_fields = automatorwp_mautic_get_contact_fields( );

    $results = array();

    // Parse company results to match select2 results
    foreach ( $contact_fields as $field ) {

        $results[] = array(
            'id' => $field['id'],
            'text' => $field['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_mautic_get_contact_fields', 'automatorwp_mautic_ajax_get_contact_fields' );

